% ------------------------------------------------------------------------
% Script: infile_1d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 1D P-N model
% ------------------------------------------------------------------------

    % % System name
 
    system='1D P-N model';
 
    % % The absolute path to save the result files
 
    filepath=pwd;
 
    % % The dimension of P-N model: 1 or 2
 
    misdim=1;
 
%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';
    
    % % The data of GSFE (unit: J/m2) and normalized disregistry vector (unit:1)
    
    Ux=[0.00194
0.02357
0.03979
0.05488
0.06887
0.07986
0.09273
0.10671
0.11715
0.12871
0.14157
0.15313
0.16357
0.17699
0.19209
0.20905
0.22583
0.24913
0.27709
0.29331
0.31419
0.33749
0.36434
0.39211
0.4225
0.44748
0.47134
0.50023
0.53472
0.56306
0.5858
0.61022
0.63166
0.65552
0.67714
0.69802
0.71834
0.7463
0.76308
0.7765
0.79514
0.80968
0.82646
0.841
0.85554
0.86729
0.8835
0.90047
0.91501
0.93477
0.94856
0.96031
0.97951
1.00095];
    SFE=[0.01598
0.02392
0.0627
0.17553
0.29366
0.43381
0.58543
0.76349
0.90982
1.07466
1.24744
1.41051
1.55332
1.71287
1.88035
2.05401
2.19416
2.32022
2.38369
2.3784
2.33697
2.24353
2.10866
1.96321
1.81159
1.71551
1.65733
1.62472
1.66615
1.74813
1.83628
1.95704
2.07604
2.2021
2.30435
2.36429
2.38898
2.34226
2.26292
2.18535
2.04255
1.89446
1.70141
1.50924
1.30826
1.14606
0.9204
0.6868
0.50786
0.2822
0.1341
0.05741
0.01863
0.00981];
    
    % % Which trial function of disregistry vector to employ (>=1)
    
    Nmis=6;
       
    % % Considering the first-order approximation in the trial function of disregistry
    %   vector (1) or NOT (0)
    
    mis_1st=0;
    
    % % The value of Burgers Vector (unit: A)
 
    BurVect=5.75; 
    
    % % The values of shear modulus (unit: GPa) and Poisson's ratio (unit: 1)
 
    shear_modulus=117;
    poisson_ratio=0.2595;
    
    % % The dislocation type: edge ('e') or screw ('s')

    mistype='e';
    
    % % Which GSFE fitting function to employ (>=0)
    
    fitcut=6;
    
    % % Matrix of the lower and upper bounds, and initial values of each unknown 
    %   variable ([Lower bound, Upper bound, StartPoint]) 
    
    Xcoef_range=[  0.0000,  0.5000,  0.1667];
    Xdist_range=[-20.0000, 20.0000,  6.0000];
    Xwid_range =[  0.0000, 10.0000,  0.2000];
    Xalpha_range=[ 0.0000,  2.00000, 1.0000];
    
    % % The mothed for fitting the restoring force: "1d_fitting_toolbox" or "1d_lsq_curvefit"
    
    fitmethod='1d_fitting_toolbox';
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------
 
    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='TRUE';
 
    % % The method to calculate the Peierls stress: 1 or 2
    
    pnstrmethod=2;
 
    % % Interplanar distance ?x (unit: A) 

    Inpas=5.75;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field around dislocation core
% ------------------------------------------------------------------------
 
    % % Calculating the pressure field around dislocation core ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice matrix for pressure field
    
    % pressfld_latxz=[];
    % pressfld_latyy=[];
